<?php
class Basket
{
  private $dbo = null;
  function __construct($dbo)
  {
    $this->dbo = $dbo;
    
    //Utworzenie koszyka, jeśli to konieczne
    if(!isset($_SESSION['basket'])){
      $_SESSION['basket'] = array();
    }
  }
  
  function add()
  {
    //Sprawdzenie poprawności parametru id
    if(!isset($_GET['id'])){
      return FORM_DATA_MISSING;
    }
    if(($id = (int) $_GET['id']) < 1){
      return INVALID_ID;
    }
    
    //Sprawdzenie czy istnieje książka o podanym id
    $query = "SELECT Cena FROM ksiazki WHERE id=$id";
    if(($cena = $this->dbo->getQuerySingleResult($query)) === false){
      return INVALID_ID;
    }
    
    //Zapisanie identyfikatora książki w koszyku
    if(isset($_SESSION['basket'][$id])){
      $_SESSION['basket'][$id]->ile++;
      $_SESSION['basket'][$id]->cena = $cena;
    }
    else{
      $_SESSION['basket'][$id] = new BasketItem($id, $cena, 1);
    }
    return ACTION_OK;
  }
  
  function show($title, $allowModify = true)
  {
    if(count($_SESSION['basket']) == 0){
      $komunikat = 'Koszyk jest pusty.';
    }
    else{
      //Pobranie listy identyfikatorów dla warunku zapytania
      $ids = implode(',', array_keys($_SESSION['basket']));
      
      //Pobranie danych dotyczących książek z koszyka
      $query  = 'SELECT `Id`, `Tytuł`, `Cena` FROM Ksiazki '
              . 'WHERE `Id` IN('.$ids.') ORDER BY `Tytuł`';
      
      //Tutaj można sprawdzić czy nie zmianiły się ceny książek
      
      if($books = $this->dbo->query($query)){
        $basket = $_SESSION['basket'];
        $komunikat = false;
      }
      else{
        $komunikat = 'Błąd serwera. Zawartość koszyka nie jest dostępna.';
      }
    }
    include 'templates/basket.php';
  }
  
  function modify()
  {
    foreach($_SESSION['basket'] as $id => $item){
      if(!isset($_POST[$id])){
        unset($_SESSION['basket'][$id]);
      }
      else if($_POST[$id] < 1){
        unset($_SESSION['basket'][$id]);
      }
      else{
        $item->ile = (int) $_POST[$id];
      }
    }
  }
  
  function saveOrder(&$orderId)
  {
    //Sprawdzenie czy koszyk ma zawartość
    if(count($_SESSION['basket']) < 1){
      return EMPTY_BASKET;
    }
    
    //Sprawdzenie czy użytkownik jest zalogowany
    if(!isset($_SESSION['zalogowany'])){
      return LOGIN_REQUIRED;
    }
    
    //Pobranie identyfikatorów książek z koszyka
    $ids = implode(',', array_keys($_SESSION['basket']));
    $userId = $_SESSION['zalogowany']->id;
    
    //Wyłączenie automatycznego zatwierdzania transakcji
    $this->dbo->autocommit(false);
    
    //Utworzenie nowego zamówienia
    $query  = 'INSERT INTO Zamowienia '
            . "VALUES(0, $userId, NOW(), NULL, 0)";
    
    if(!$this->dbo->query($query)){
      return SERVER_ERROR;
    }
    
    if(($orderId = $this->dbo->insert_id) < 1){
      return SERVER_ERROR;
    }
    
    foreach($_SESSION['basket'] as $item){
      $id = $item->id;
      $cena = $item->cena;
      $ile = $item->ile;
      $query = "INSERT INTO KsiazkiZamowienia VALUES($id, $orderId,"
             . "$ile, $cena)";
      
      //Jeśli nie udało się wykonać zapytania
      if(!$this->dbo->query($query)){
        return SERVER_ERROR;
      }
      
      //Jeśli liczba dodanych rekordów inna niż 1
      if($this->dbo->affected_rows <> 1){
        return SERVER_ERROR;
      }
    }
    
    //Zatwierdzenie transakcji
    $this->dbo->commit();
    
    //Wyczyszczenie koszyka
    $_SESSION['basket'] = array();
    
    return ACTION_OK;
  }
  
}
?>
